<?php
session_start();
require_once '../config/db.php';

// التحقق من صلاحية الدخول
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../src/login.php');
    exit;
}

// جلب الإحصائيات
$total_projects = $pdo->query('SELECT COUNT(*) FROM projects')->fetchColumn();
$completed_projects = $pdo->query("SELECT COUNT(*) FROM projects WHERE status = 'مكتمل'")->fetchColumn();
$in_progress_projects = $pdo->query("SELECT COUNT(*) FROM projects WHERE status = 'تحت الانشاء'")->fetchColumn();
$sold_projects = $pdo->query("SELECT COUNT(*) FROM projects WHERE status = 'تم البيع'")->fetchColumn();
$total_users = $pdo->query('SELECT COUNT(*) FROM users')->fetchColumn();
$new_messages = $pdo->query("SELECT COUNT(*) FROM messages WHERE status = 'جديد'")->fetchColumn();

?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: #EEEEEE; font-family: 'Cairo', sans-serif; }
        .dashboard-container { max-width: 1000px; margin: 40px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 24px; text-align: center; }
        .cards { display: flex; flex-wrap: wrap; gap: 24px; justify-content: center; margin-bottom: 32px; }
        .card { background: #EA9218; color: #fff; border-radius: 8px; box-shadow: 0 0 8px #31384122; padding: 24px; min-width: 180px; text-align: center; font-size: 20px; flex: 1; }
        .card-title { font-size: 16px; margin-bottom: 8px; color: #EEEEEE; }
        .quick-links { display: flex; gap: 16px; justify-content: center; margin-top: 24px; }
        .quick-link { background: #3A4750; color: #fff; padding: 12px 24px; border-radius: 6px; text-decoration: none; font-size: 16px; transition: background 0.2s; }
        .quick-link:hover { background: #313841; }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <h2>لوحة التحكم الإدارية</h2>
        <div class="cards">
            <div class="card">
                <div class="card-title">إجمالي المشاريع</div>
                <div><?= $total_projects ?></div>
            </div>
            <div class="card">
                <div class="card-title">مشاريع مكتملة</div>
                <div><?= $completed_projects ?></div>
            </div>
            <div class="card">
                <div class="card-title">تحت الإنشاء</div>
                <div><?= $in_progress_projects ?></div>
            </div>
            <div class="card">
                <div class="card-title">تم البيع</div>
                <div><?= $sold_projects ?></div>
            </div>
            <div class="card">
                <div class="card-title">عدد المستخدمين</div>
                <div><?= $total_users ?></div>
            </div>
            <div class="card">
                <div class="card-title">رسائل جديدة</div>
                <div><?= $new_messages ?></div>
            </div>
        </div>
        <div class="quick-links">
            <a class="quick-link" href="users.php">إدارة المستخدمين</a>
            <a class="quick-link" href="projects.php">إدارة المشاريع</a>
            <a class="quick-link" href="messages.php">استفسارات العملاء</a>
            <a class="quick-link" href="settings.php">الإعدادات العامة</a>
            <a class="quick-link" href="logout.php">تسجيل الخروج</a>
        </div>
    </div>
</body>
</html>
